// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 4 %t.exe 2>&1 | %filecheck %s

// CHECK: [MUST-REPORT]{{.*The application issued a set of MPI calls that can cause a deadlock!}}
// CHECK-DAG: MPI_Waitany
// CHECK-DAG: MPI_Win_wait

/**
 * @file PSCWMixedComplexDl.cpp
 * MPI-RMA PSCW test case 
 *
 * Description:
 * This test deadlocks because ranks >1 wait for the completion of MPI_Irecv calls with MPI_Waitany
 * inside the PSCW epochs ,while ranks >0 delay their matching MPI_Send until after completing the RMA
 * epoch. (Error)
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char* argv[])
{
    MPI_Init(&argc, &argv);

    int rank, size;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    // Ensure we have at least two processes
    if (size < 4) {
        if (rank == 0) {
            std::cerr << "This program requires at least 4 processes.\n";
        }
        MPI_Finalize();
        return 1;
    }

    if (rank == 0)
        std::cout << "Executing with " << size << " processes" << std::endl;

    int winBuffer = rank;
    MPI_Win win;
    MPI_Win_create(&winBuffer, sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    MPI_Group world_group, self_group, other_group;

    MPI_Comm_group(MPI_COMM_WORLD, &world_group);
    MPI_Comm_group(MPI_COMM_SELF, &self_group);
    MPI_Group_difference(world_group, self_group, &other_group);

    MPI_Win_post(world_group, 0, win);
    MPI_Win_start(world_group, 0, win);

    if (rank > 1) {
        int p2pBuffer[size];
        int rmaBuffer = 100;
        MPI_Put(&rmaBuffer, 1, MPI_INT, 1, 0, 1, MPI_INT, win);
        std::vector<MPI_Request> reqs(size, MPI_REQUEST_NULL);
        for (int i = 0; i < size; i++)
            MPI_Irecv(&p2pBuffer[i], 1, MPI_INT, i, 0, MPI_COMM_WORLD, &reqs[i]);
        int index = 0;
        MPI_Waitany(size, reqs.data(), &index, MPI_STATUS_IGNORE);
    }
    MPI_Win_complete(win);
    MPI_Win_wait(win);
    if (rank > 0) {
        int targetRank = 0;
        int p2pBuffer = 200;
        MPI_Send(&p2pBuffer, 1, MPI_INT, targetRank, 0, MPI_COMM_WORLD);
    }

    // Cleanup
    MPI_Group_free(&world_group);
    MPI_Win_free(&win);

    MPI_Finalize();
    return 0;
}
