// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 2 %t.exe 2>&1 | %filecheck %s

// CHECK: [MUST-REPORT]{{.*The application issued a set of MPI calls that can cause a deadlock!}}
// CHECK-DAG: MPI_Recv@rank 0
// CHECK-DAG: MPI_Win_wait@rank 1

/**
 * @file PSCWMixedDl.cpp
 * MPI-RMA PSCW test case 
 *
 * Description:
 * This test case deadlocks because rank 0 blocks in a MPI_Recv inside an RMA access epoch
 * before calling MPI_Win_complete, while rank 1 waits in MPI_Win_wait for the MPI_Win_complete 
 * before calling the matching MPI_Send. (Error)
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char* argv[])
{
    MPI_Init(&argc, &argv);

    int rank, size;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    // Ensure we have at least two processes
    if (size < 2) {
        if (rank == 0) {
            std::cerr << "This program requires at least 2 processes.\n";
        }
        MPI_Finalize();
        return 1;
    }

    if (rank == 0)
        std::cout << "Executing with " << size << " processes" << std::endl;

    int winBuffer = rank;
    MPI_Win win;
    MPI_Win_create(&winBuffer, sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    MPI_Group world_group;
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);
    int p2pBuffer = 0;

    if (rank == 0) {
        MPI_Group group;
        int targetRank = 1;
        MPI_Group_incl(world_group, 1, &targetRank, &group);
        int rmaBuffer = 100;
        MPI_Win_start(group, 0, win);
        MPI_Put(&rmaBuffer, 1, MPI_INT, targetRank, 0, 1, MPI_INT, win);
        MPI_Recv(&p2pBuffer, 1, MPI_INT, targetRank, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
        MPI_Win_complete(win);
        MPI_Group_free(&group);
    } else if (rank == 1) {
        MPI_Group group;
        int targetRank = 0;
        MPI_Group_incl(world_group, 1, &targetRank, &group);
        MPI_Win_post(group, 0, win);
        MPI_Win_wait(win);
        p2pBuffer = 200;
        MPI_Send(&p2pBuffer, 1, MPI_INT, targetRank, 0, MPI_COMM_WORLD);
        MPI_Group_free(&group);
    }

    // Cleanup
    MPI_Group_free(&world_group);
    MPI_Win_free(&win);

    MPI_Finalize();
    return 0;
}
