// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 2 %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file PSCWMultipleWinsNoDl.cpp
 * MPI-RMA PSCW test case that uses interleaved PSCW epochs on different wins
 *
 * Description:
 * There is no error in this test case (No-Error)
 * 
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char* argv[])
{
    MPI_Init(&argc, &argv);

    int rank, size;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    // Ensure we have at least two processes
    if (size < 2) {
        if (rank == 0) {
            std::cerr << "This program requires at least 2 processes.\n";
        }
        MPI_Finalize();
        return 1;
    }

    if (rank == 0)
        std::cout << "Executing with " << size << " processes" << std::endl;

    int winBuffer1 = rank, winBuffer2 = rank;
    MPI_Win win1, win2;
    MPI_Win_create(&winBuffer1, sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win1);
    MPI_Win_create(&winBuffer2, sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win2);

    MPI_Group world_group;
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);

    MPI_Win_post(world_group, 0, win1);
    MPI_Win_post(world_group, 0, win2);
    MPI_Win_start(world_group, 0, win1);
    MPI_Win_start(world_group, 0, win2);
    MPI_Win_complete(win1);
    MPI_Win_complete(win2);
    MPI_Win_wait(win1);
    MPI_Win_wait(win2);

    // // Cleanup
    MPI_Group_free(&world_group);
    MPI_Win_free(&win1);
    MPI_Win_free(&win2);

    MPI_Finalize();
    return 0;
}
