// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 2 %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file PSCWdoubleStartNoDl.cpp
 * This MPI-RMA PSCW (Post-Start-Complete-Wait) test performs two consecutive MPI_Win_start 
 * / MPI_Win_complete epochs targeting two disjoint groups (firstG and secondG) whose union 
 * equals the group used in MPI_Win_post.
 *
 * Description:
 * There is no error in this test case (No-Error)
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <stdio.h>
int main(int argc, char** argv)
{
    int rank, size;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    //Enough tasks ?
    if (size < 2) {
        printf("This test needs at least 2 processes!\n");
        MPI_Finalize();
        return 1;
    }

    MPI_Win win;
    MPI_Group world_group, self_group, other_group;
    int* win_buffer;
    MPI_Win_allocate(
        10 * sizeof(int),
        sizeof(int),
        MPI_INFO_NULL,
        MPI_COMM_WORLD,
        &win_buffer,
        &win);
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);
    MPI_Comm_group(MPI_COMM_SELF, &self_group);
    MPI_Group_difference(world_group, self_group, &other_group);

    MPI_Group firstG, secondG;
    int firstT = 0;
    MPI_Group_incl(world_group, 1, &firstT, &firstG);
    MPI_Group_difference(world_group, firstG, &secondG);

    MPI_Win_post(world_group, 0, win);
    MPI_Win_start(firstG, 0, win);
    int local_buf[10] = {0};
    if (rank == 0)
        MPI_Put(&local_buf, 10, MPI_INT, rank, 0, 10, MPI_INT, win);
    MPI_Win_complete(win);

    MPI_Win_start(secondG, 0, win);
    if (rank == 1)
        MPI_Put(&local_buf, 10, MPI_INT, rank, 0, 10, MPI_INT, win);
    MPI_Win_complete(win);

    MPI_Win_wait(win);
    MPI_Group_free(&world_group);
    MPI_Group_free(&other_group);
    MPI_Group_free(&self_group);
    MPI_Group_free(&firstG);
    MPI_Group_free(&secondG);

    MPI_Win_free(&win);
    MPI_Finalize();

    return 0;
}