// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 3 %t.exe 2>&1 | %filecheck %s

// CHECK: [MUST-REPORT]{{.*The application issued a set of MPI calls that can cause a deadlock!}}
// CHECK: MPI_Win_start

/**
 * @file PSCWsubGroupDl-1.cpp
 * MPI-RMA PSCW test case on a subset of ranks 
 *
 * Description:
 * This test case deadlocks because the MPI_Win_start and MPI_Win_post calls use disjoint groups (Error)
 * 
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char* argv[])
{
    MPI_Init(&argc, &argv);

    int rank, size;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    // Ensure we have at least two processes
    if (size < 3) {
        if (rank == 0) {
            std::cerr << "This program requires at least 3 processes.\n";
        }
        MPI_Finalize();
        return 1;
    }

    if (rank == 0)
        std::cout << "Executing with " << size << " processes" << std::endl;

    int buffer = rank;
    MPI_Win win;
    MPI_Win_create(&buffer, sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    MPI_Group world_group, inGroup, outGroup;
    int inRanks[2] = {(rank - 1 + size) % size, (rank + 1) % size};
    // Some MPI_Win_start calls expect a MPI_Win_post from rank 0 which will not come
    int outRanks[2] = {0, (rank + 1) % size};
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);
    MPI_Group_incl(world_group, 2, inRanks, &inGroup);
    MPI_Group_incl(world_group, 2, outRanks, &outGroup);

    MPI_Win_post(inGroup, 0, win);
    MPI_Win_start(outGroup, 0, win);
    MPI_Win_complete(win);
    MPI_Win_wait(win);

    // Cleanup
    MPI_Group_free(&inGroup);
    MPI_Group_free(&outGroup);
    MPI_Group_free(&world_group);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
