// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 3 %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file PSCWsubGroupNoDl.cpp
 * MPI-RMA PSCW test case on a subset of ranks 
 *
 * Description:
 * There is no error in this test case (No-Error)
 * 
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char* argv[])
{
    MPI_Init(&argc, &argv);

    int rank, size;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    // Ensure we have at least two processes
    if (size < 3) {
        if (rank == 0) {
            std::cerr << "This program requires at least 3 processes.\n";
        }
        MPI_Finalize();
        return 1;
    }

    if (rank == 0)
        std::cout << "Executing with " << size << " processes" << std::endl;

    int buffer = rank;
    MPI_Win win;
    MPI_Win_create(&buffer, sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    MPI_Group world_group, sub_group;
    int ranks[2] = {(rank - 1 + size) % size, (rank + 1) % size};
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);
    MPI_Group_incl(world_group, 2, ranks, &sub_group);

    MPI_Win_post(sub_group, 0, win);
    MPI_Win_start(sub_group, 0, win);
    MPI_Win_complete(win);
    MPI_Win_wait(win);

    MPI_Barrier(MPI_COMM_WORLD);

    // Cleanup
    MPI_Group_free(&sub_group);
    MPI_Group_free(&world_group);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
