// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 2 %t.exe 2>&1 | %filecheck %s

// CHECK: [MUST-REPORT]{{.*The application issued a set of MPI calls that can cause a deadlock!}}
// CHECK: MPI_Win_wait

/**
 * @file PSCWworldGroupDl-2.cpp
 * MPI-RMA PSCW test case on a subset of ranks 
 *
 * Description:
 * This test case deadlocks because process 0 does not call MPI_Win_complete, 
 * causing MPI_Win_wait of the other processes to block. (Error)
 * 
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char* argv[])
{
    MPI_Init(&argc, &argv);

    int rank, size;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    // Ensure we have at least two processes
    if (size < 2) {
        if (rank == 0) {
            std::cerr << "This program requires at least 2 processes.\n";
        }
        MPI_Finalize();
        return 1;
    }

    if (rank == 0)
        std::cout << "Executing with " << size << " processes" << std::endl;

    int buffer = rank;
    MPI_Win win;
    MPI_Win_create(&buffer, sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    MPI_Group world_group;
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);

    MPI_Win_post(world_group, 0, win);
    MPI_Win_start(world_group, 0, win);
    if (rank == 0)
        MPI_Win_complete(win);
    MPI_Win_wait(win);

    // Cleanup
    MPI_Group_free(&world_group);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
