/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file waitAnySourceEx6NoDl.c
 * Complex example that tries to enforce the "deciding" mode of must (if queues become too big).
 *
 * Description:
 * No deadlock, just a late completion.
 *
 * @author Tobias Hilbrich
 */

// RUN: %compile-cc
// RUN: %must-run %mpiexec-numproc-flag 4 %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck --check-prefix 'CHECK-LOCAL' %s

#include <mpi.h>
#include <stdio.h>

int main(int argc, char** argv)
{
    int rank, size, buf, buf2, buf3, i;
    MPI_Status status;
    MPI_Request request, request2;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    //Enough tasks ?
    if (size < 4) {
        printf("This test needs at least 4 processes!\n");
        MPI_Finalize();
        return 1;
    }

    //Say hello
    printf("Hello, I am rank %d of %d processes.\n", rank, size);

    //Irecv with match, we complete it later
    MPI_Irecv(&buf3, 1, MPI_INT, MPI_ANY_SOURCE, 666, MPI_COMM_WORLD, &request);
    MPI_Send(&buf, 1, MPI_INT, (rank + 1) % size, 666, MPI_COMM_WORLD);

    //Lots of other comm.
    for (i = 0; i < 50000; i++) {
        MPI_Irecv(&buf2, 1, MPI_INT, (rank - 1 + size) % size, 666, MPI_COMM_WORLD, &request2);
        MPI_Send(&buf, 1, MPI_INT, (rank + 1) % size, 666, MPI_COMM_WORLD);
        MPI_Wait(&request2, &status);
    }

    //Now complete and do an additional round of wild-card communication
    MPI_Wait(&request, &status);
    MPI_Irecv(&buf2, 1, MPI_INT, MPI_ANY_SOURCE, 666, MPI_COMM_WORLD, &request);
    MPI_Send(&buf, 1, MPI_INT, (rank + 1) % size, 666, MPI_COMM_WORLD);
    MPI_Wait(&request, &status);

    //Say bye bye
    printf("Signing off, rank %d.\n", rank);

    //ERROR: All ranks are lacking a Wait for the Irecv, Rank 0 lacks a Send call
    MPI_Finalize();

    return 0;
}
