/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file I_PrintFile.h
 *       @see I_PrintFile.
 *
 *  @date 12.05.2011
 *  @author Tobias Hilbrich
 */

#include "I_Module.h"
#include "GtiEnums.h" //TODO Needs to be renamed to GTI enums
#include "BaseIds.h"
#include "I_FileTrack.h"
#include "I_LocationAnalysis.h"

#ifndef I_PRINTFILE_H
#define I_PRINTFILE_H

/**
 * Interface for a module that prints all available
 * information on an fileorhandler, using I_FileTrack.
 *
 * Dependencies:
 *  1) LocationAnalysis
 *  2) CreateMessage
 *  3) FileTrack
 */
class I_PrintFile : public gti::I_Module
{
  public:
    /**
	 * Prints information on the given file as log events.
	 * @param pId parallel Id of the print call.
	 * @param lId location Id of the print call.
	 * @param file to print.
	 * @return @see gti::GTI_ANALYSIS_RETURN.
	 */
    virtual gti::GTI_ANALYSIS_RETURN
    print(MustParallelId pId, MustLocationId lId, MustFileType file) = 0;

}; /*class I_PrintFile*/

#endif /*I_PRINTFILE_H*/
