/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file PrintFile.h
 *       @see MUST::PrintFile.
 *
 *  @date 12.05.2011
 *  @author Tobias Hilbrich
 */

#include "ModuleBase.h"
#include "I_CreateMessage.h"

#include "I_PrintFile.h"

#ifndef PRINTFILE_H
#define PRINTFILE_H

using namespace gti;

namespace must
{
/**
     * Implementation of I_PrintFile.
     */
class PrintFile : public gti::ModuleBase<PrintFile, I_PrintFile>
{
  public:
    /**
         * Constructor.
         * @param instanceName name of this module instance.
         */
    PrintFile(const char* instanceName);

    /**
    		 * Destructor.
    		 */
    virtual ~PrintFile(void);

    /**
    		 * @see I_PrintFile::print.
    		 */
    GTI_ANALYSIS_RETURN print(MustParallelId pId, MustLocationId lId, MustFileType file);

  protected:
    I_CreateMessage* myLogger;
    I_FileTrack* myFileTracker;
    I_LocationAnalysis* myLocations;
}; /*class PrintFile */
} // namespace must

#endif /*PRINTFILE_H*/
