/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cc
// RUN: %must-run %mpiexec-numproc-flag 2 --must:layout \
// RUN: %builddir/tests/FileTrack/layout.xml --must:analyses \
// RUN: %builddir/tests/FileTrack/analysis_spec.xml \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

/**
 * @file testFileTrack.c
 * A must test case for filehandler tracking.
 *
 * @author Tobias Hilbrich
 *
 */

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "mustFeaturetested.h"
#include "mustTest.h"

#define TEST_FILE(F)                                                                               \
    fFile = MUST_File_m2i(F);                                                                      \
    MPI_Initialized((int*)&fFile)

/**
 * Performs the following actions:
 * (Using any number of processes)
 *
 * 1) Tests predefined errhandlers
 * 2) Creates a new errhandler
 * 3) Frees the errhandler
 */
int main(int argc, char** argv)
{
    char* filename;
    int rank, size, cmode;
    MPI_File fh;
    MustFileType fFile;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    filename = "testFileTrack.txt";

    MPI_File_open(
        MPI_COMM_WORLD,
        filename,
        MPI_MODE_CREATE | MPI_MODE_WRONLY | MPI_MODE_DELETE_ON_CLOSE,
        MPI_INFO_NULL,
        &fh);
    // CHECK-DAG: [MUST-REPORT]{{.*Information.*Information on file: File created at reference}}
    TEST_FILE(fh);
    MPI_File_close(&fh);
    // CHECK-DAG: [MUST-REPORT]{{.*Information.*Information on file: MPI_FILE_NULL.*}}
    TEST_FILE(fh);

    printf("Signing off: %d of %d tasks.\n", rank, size);
    MPI_Finalize();
    return 0;
}
