/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// CHECK: [MUST-REPORT] MUST detected no MPI usage errors nor any suspicious behavior during this application run.

/**
 * @file KeyDefinedNoWarning.cpp
 * This is a test for the analysis group InfoChecks.
 *
 * Description:
 * Performs a MPI_Info_get_string on a key which does exist in info.
 * This causes no warning
 */

#include <iostream>
#include <mpi.h>
#include <string.h>
using namespace std;

int main(int argc, char** argv)
{
    int rank, size;

    MPI_Info info;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    printf("Ready: %d of %d tasks.\n", rank, size);

    //Enough tasks ?
    if (size < 1) {
        printf("Not enough tasks, need 1 at least.\n");
        MPI_Finalize();
        exit(1);
    }

    MPI_Info_create(&info);

    char *key = "defined", value;
    int buflen = MPI_MAX_INFO_VAL * sizeof(char), flag;

    MPI_Info_set(info, key, "notnull");

#ifdef HAVE_MPI_INFO_GET_STRING
    MPI_Info_get_string(info, key, &buflen, value, &flag);
#else printf("MPI_Info_get_string is not supported.\n");
#endif

    MPI_Info_free(&info);

    printf("Signing off: %d of %d tasks.\n", rank, size);
    MPI_Finalize();
    return 0;
}
