/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

/**
 * @file KeyNotDefinedError.cpp
 * This is a test for the analysis group InfoChecks.
 *
 * Description:
 * Performs a MPI_Info_delete on a key that does not exist in info.
 * This causes an error
 */

#include <iostream>
#include <mpi.h>
#include <string.h>
using namespace std;

int main(int argc, char** argv)
{
    int rank, size;

    MPI_Info info;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    printf("Ready: %d of %d tasks.\n", rank, size);

    //Enough tasks ?
    if (size < 1) {
        printf("Not enough tasks, need 1 at least.\n");
        MPI_Finalize();
        exit(1);
    }

    MPI_Info_create(&info);

    char* key = "notdefined";
    // CHECK: [MUST-REPORT] Error: from: call MPI_Info_delete@{{[01]}}: Key notdefined is not defined in argument 1 (info)!
    MPI_Info_delete(info, key);

    MPI_Info_free(&info);

    printf("Signing off: %d of %d tasks.\n", rank, size);
    MPI_Finalize();
    return 0;
}
