/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file I_PrintInfo.h
 *       @see I_PrintInfo.
 *
 *  @date 12.05.2011
 *  @author Tobias Hilbrich
 */

#include "I_Module.h"
#include "GtiEnums.h" //TODO Needs to be renamed to GTI enums
#include "BaseIds.h"
#include "I_InfoTrack.h"
#include "I_LocationAnalysis.h"

#ifndef I_PRINTINFO_H
#define I_PRINTINFO_H

/**
 * Interface for a module that prints all available
 * information on info, using I_InfoTrack.
 *
 * Dependencies:
 *  1) LocationAnalysis
 *  2) CreateMessage
 *  3) InfoTrack
 */
class I_PrintInfo : public gti::I_Module
{
  public:
    /**
	 * Prints information on the given info handle as log events.
	 * @param pId parallel Id of the print call.
	 * @param lId location Id of the print call.
	 * @param infoHandle to print.
	 * @return @see gti::GTI_ANALYSIS_RETURN.
	 */
    virtual gti::GTI_ANALYSIS_RETURN
    print(MustParallelId pId, MustLocationId lId, MustInfoType infoHandle) = 0;

}; /*class I_PrintInfo*/

#endif /*I_PRINTINFO_H*/
