/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file PrintInfo.h
 *       @see MUST::PrintInfo.
 *
 *  @date 12.05.2011
 *  @author Tobias Hilbrich
 */

#include "ModuleBase.h"
#include "I_CreateMessage.h"

#include "I_PrintInfo.h"

#ifndef PRINTINFO_H
#define PRINTINFO_H

using namespace gti;

namespace must
{
/**
     * Implementation of I_PrintInfo.
     */
class PrintInfo : public gti::ModuleBase<PrintInfo, I_PrintInfo>
{
  public:
    /**
         * Constructor.
         * @param instanceName name of this module instance.
         */
    PrintInfo(const char* instanceName);

    /**
    		 * Destructor.
    		 */
    virtual ~PrintInfo(void);

    /**
    		 * @see I_PrintInfo::print.
    		 */
    GTI_ANALYSIS_RETURN print(MustParallelId pId, MustLocationId lId, MustInfoType infoHandle);

  protected:
    I_CreateMessage* myLogger;
    I_InfoTrack* myInfoTracker;
    I_LocationAnalysis* myLocations;
}; /*class PrintInfo */
} // namespace must

#endif /*PRINTINFO_H*/
