/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cc
// RUN: %must-run %mpiexec-numproc-flag 2 --must:layout \
// RUN: %builddir/tests/InfoTrack/layout.xml --must:analyses \
// RUN: %builddir/tests/InfoTrack/analysis_spec.xml \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

/**
 * @file testInfoTrack.c
 * A must test case for info tracking.
 *
 * @author Tobias Hilbrich
 *
 */

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>
#include "mustFeaturetested.h"
// #include "mustTest.h"

// #define TEST_INFO(R) MPI_Initialized(&R)
#define TEST_INFO(R)                                                                               \
    fInfo = MUST_Info_m2i(R);                                                                      \
    MPI_Initialized((int*)&fInfo)

/**
 * Performs the following actions:
 * (Using any number of processes)
 *
 * 1) Tests predefined infos
 * 2) Creates a new info
 * 3) Frees the info
 */
int main(int argc, char** argv)
{
    int rank, size;

    MustInfoType fInfo;
    MPI_Info myInfo;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    printf("Ready: %d of %d tasks.\n", rank, size);

    //Enough tasks ?
    if (size < 1) {
        printf("Not enough tasks, need 1 at least.\n");
        MPI_Finalize();
        exit(1);
    }

    //==1) Base Infos
    // CHECK-DAG: [MUST-REPORT]{{.*MPI_INFO_ENV.*}}
    TEST_INFO(MPI_INFO_ENV);

    //==2) Info create
    MPI_Info_create(&myInfo);
    // CHECK-DAG: [MUST-REPORT]{{.*Info created at.*}}
    // CHECK: MPI_Info_create
    TEST_INFO(myInfo);

    //==3) Info free
    MPI_Info_free(&myInfo);

    printf("Signing off: %d of %d tasks.\n", rank, size);
    MPI_Finalize();
    return 0;
}
