/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cc
// RUN: %must-run %mpiexec-numproc-flag 2 %t.exe 2>&1 \
// RUN: | %filecheck %s

// CHECK: [MUST-REPORT]{{.*There are 1 windows that are not freed when MPI_Finalize}}

/**
 * @file LeakWinError.c
 * This is a a test for the analysis LeakChecks.
 *
 * Description:
 * This test leaks a window.
 *
 *
 *  @date 04.02.2025
 *  @author Cornelius Pätzold
 */

#include <mpi.h>
#include <stdio.h>

int main(int argc, char** argv)
{
    int size, rank;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    //Enough tasks ?
    if (size < 2) {
        printf("This test needs at least 2 processes!\n");
        MPI_Finalize();
        return 1;
    }

    int win_buffer[10];
    MPI_Win win;
    MPI_Win_create(win_buffer, 10 * sizeof(int), 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);
    MPI_Finalize();

    return 0;
}
