// REQUIRES: tsan

// RUN: %must-cc %s -o %t.exe
// RUN: %must-run-tsan --must:distributed %mpiexec-numproc-flag 2 \
// RUN: --must:output-dir %t %t.exe 2>&1 | %filecheck %check-prefixes %s

// FIBER-DAG: Request from call MPI_Ibcast
// NOFIBER-DAG: {{.*data race.*MPI_Ibcast}}

#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include <omp.h>

#define NUM_THREADS 12

int main(int argc, char* argv[])
{
    int provided;
    int* buf = (int*)calloc(12, sizeof(int));

    MPI_Init_thread(&argc, &argv, MPI_THREAD_FUNNELED, &provided);

    if (provided < MPI_THREAD_FUNNELED) {
        printf("MPI level insufficient\n");
        MPI_Abort(MPI_COMM_WORLD, 1);
    }

    MPI_Request req;

#pragma omp parallel num_threads(NUM_THREADS)
    {
        // CHECK-ST-DAG: ibcast.c:[[@LINE+1]]
        buf[omp_get_thread_num()] = 4;
#pragma omp master
        {
            // CHECK-ST-DAG: ibcast.c:[[@LINE+1]]
            MPI_Ibcast(buf, NUM_THREADS, MPI_INT, 0, MPI_COMM_WORLD, &req);
            MPI_Wait(&req, MPI_STATUS_IGNORE);
        }
    }

    MPI_Finalize();

    return EXIT_SUCCESS;
}
