// REQUIRES: tsan

// RUN: %must-cc %s -o %t.exe
// RUN: %must-run-tsan %mpiexec-numproc-flag 2 \
// RUN: --must:output-dir %t %t.exe 2>&1 | %filecheck %check-prefixes %s

// FIBER-DAG: {{Request from call MPI_Irecv|.*data race.*MPI_Irecv}}
// NOFIBER-DAG: {{.*data race.*MPI_Irecv}}

#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include <omp.h>

#define NUM_THREADS 6

int main(int argc, char* argv[])
{
    int provided;
    int *sdata, *rdata, rank, size;
    rdata = calloc(NUM_THREADS, sizeof(int));
    sdata = calloc(NUM_THREADS, sizeof(int));

    MPI_Init_thread(&argc, &argv, MPI_THREAD_FUNNELED, &provided);

    char buf;
    MPI_Bcast(&buf, 1, MPI_CHAR, 0, MPI_COMM_WORLD);
    if (provided < MPI_THREAD_FUNNELED) {
        printf("MPI level insufficient\n");
        MPI_Abort(MPI_COMM_WORLD, 1);
    }
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Request req;
    MPI_Isend(sdata, NUM_THREADS, MPI_INT, size - rank - 1, 42, MPI_COMM_WORLD, &req);
    printf("rdata = %p\n", rdata);
#pragma omp parallel num_threads(NUM_THREADS)
    {
        MPI_Request req2;
#pragma omp barrier
#pragma omp master
        {
            // CHECK-ST-DAG: irecv.c:[[@LINE+1]]
            MPI_Irecv(rdata, NUM_THREADS, MPI_INT, size - rank - 1, 42, MPI_COMM_WORLD, &req2);
        }
        // CHECK-ST-DAG: irecv.c:[[@LINE+1]]
        rdata[omp_get_thread_num()] = omp_get_thread_num();
#pragma omp master
        {
            MPI_Wait(&req2, MPI_STATUS_IGNORE);
        }
#pragma omp barrier
    }
    MPI_Wait(&req, MPI_STATUS_IGNORE);
    MPI_Finalize();
    return EXIT_SUCCESS;
}
