// REQUIRES: tsan

// RUN: %must-cc %s -o %t.exe
// RUN: %must-run-tsan --must:distributed %mpiexec-numproc-flag 2 \
// RUN: --must:output-dir %t %t.exe 2>&1 | %filecheck %check-prefixes %s

// FIBER-DAG: Request from call MPI_Iscatter
// NOFIBER-DAG: {{.*data race.*MPI_Iscatter}}

#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include <omp.h>

#define NUM_THREADS 12

int main(int argc, char* argv[])
{
    int provided;
    int* sbuf = (int*)calloc(NUM_THREADS * 2, sizeof(int));
    int* rbuf = (int*)calloc(NUM_THREADS, sizeof(int));

    MPI_Init_thread(&argc, &argv, MPI_THREAD_FUNNELED, &provided);

    if (provided < MPI_THREAD_FUNNELED) {
        printf("MPI level insufficient\n");
        MPI_Abort(MPI_COMM_WORLD, 1);
    }

    MPI_Request req;

#pragma omp parallel num_threads(NUM_THREADS)
    {
#pragma omp master
        // clang-format off
        // CHECK-ST-DAG: iscatter.c:[[@LINE+1]]
        MPI_Iscatter(sbuf, NUM_THREADS, MPI_INT, rbuf, NUM_THREADS, MPI_INT, 0, MPI_COMM_WORLD, &req);
        // clang-format on
        // CHECK-ST-DAG: iscatter.c:[[@LINE+1]]
        rbuf[omp_get_thread_num()] = 5;
#pragma omp master
        MPI_Wait(&req, MPI_STATUS_IGNORE);
    }

    MPI_Finalize();

    return EXIT_SUCCESS;
}
