// REQUIRES: tsan

// RUN: %must-cc %s -o %t.exe
// RUN: %must-run-tsan %mpiexec-numproc-flag 2 \
// RUN: --must:output-dir %t %t.exe 2>&1 | %filecheck %check-prefixes %s

// CHECK-DAG: {{.*data race}}

#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include <omp.h>

#define NUM_ELEM 2

int main(int argc, char* argv[])
{
    int provided;
    int *sdata, *rdata, rank, size;
    int i;
    sdata = calloc(NUM_ELEM, sizeof(int));
    rdata = calloc(NUM_ELEM, sizeof(int));

    MPI_Init_thread(&argc, &argv, MPI_THREAD_FUNNELED, &provided);
    if (provided < MPI_THREAD_FUNNELED) {
        printf("MPI level insufficient\n");
        MPI_Abort(MPI_COMM_WORLD, 1);
    }
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (rank == 0) {
        MPI_Request req1, req2;
        // CHECK-ST-DAG: isend_irecv.c:[[@LINE+1]]
        MPI_Isend(sdata, NUM_ELEM, MPI_INT, size - rank - 1, 42, MPI_COMM_WORLD, &req1);
        // CHECK-ST-DAG: isend_irecv.c:[[@LINE+1]]
        MPI_Irecv(sdata, NUM_ELEM, MPI_INT, size - rank - 1, 42, MPI_COMM_WORLD, &req2);
        MPI_Wait(&req1, MPI_STATUS_IGNORE);
        MPI_Wait(&req2, MPI_STATUS_IGNORE);
        printf("Rank 0: sdata[0] = %d, sdata[1] = %d\n", sdata[0], sdata[1]);
    } else if (rank == 1) {
        MPI_Recv(rdata, NUM_ELEM, MPI_INT, size - rank - 1, 42, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
        printf("Rank 1: rdata[0] = %d, rdata[1] = %d\n", rdata[0], rdata[1]);
        MPI_Send(rdata, NUM_ELEM, MPI_INT, size - rank - 1, 42, MPI_COMM_WORLD);
    }
    MPI_Finalize();
    return EXIT_SUCCESS;
}
