// REQUIRES: tsan,tsan-fibers

// RUN: %must-cc %s -o %t.exe
// RUN: %must-run-tsan %mpiexec-numproc-flag 2 \
// RUN: --must:output-dir %t %t.exe 2>&1 | %filecheck %check-prefixes %s

// CHECK-DAG: Request from call MPI_Isend

#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include <omp.h>

#define NUM_ELEM 2

int main(int argc, char* argv[])
{
    int provided;
    int *sdata, *rdata, rank, size;
    sdata = calloc(NUM_ELEM, sizeof(int));
    rdata = calloc(NUM_ELEM, sizeof(int));

    MPI_Init_thread(&argc, &argv, MPI_THREAD_FUNNELED, &provided);
    if (provided < MPI_THREAD_FUNNELED) {
        printf("MPI level insufficient\n");
        MPI_Abort(MPI_COMM_WORLD, 1);
    }
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (rank == 0) {
        MPI_Request req2;
        // CHECK-ST-DAG: isend_single.c:[[@LINE+1]]
        MPI_Isend(sdata, NUM_ELEM, MPI_INT, 1, 42, MPI_COMM_WORLD, &req2);
        printf("Rank 0: Write to &sdata[0] = %p, &sdata[1] = %p\n", &(sdata[0]), &(sdata[1]));
        // CHECK-ST-DAG: isend_single.c:[[@LINE+1]]
        sdata[0] = 42;
        sdata[1] = 43;
        MPI_Wait(&req2, MPI_STATUS_IGNORE);
    } else if (rank == 1) {
        MPI_Recv(rdata, NUM_ELEM, MPI_INT, 0, 42, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
        printf("Rank 1: rdata[0] = %d, rdata[1] = %d\n", rdata[0], rdata[1]);
    }

    free(rdata);
    free(sdata);
    MPI_Finalize();
    return EXIT_SUCCESS;
}
