/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cxx
// RUN: env MUST_DEBUG=TRACE  %must-run %mpiexec-numproc-flag 2 \
// RUN:   %t.exe 2>&1 \
// RUN: | %filecheck %s

// CHECK: [{{.*MUST:TRACE.*}}]

/**
 * @file InternalLogging.cpp
 * This is a a test for internal debug logging.
 *
 * There is no error in the application code,
 * but we expect some debug output (trace) from triggered analysis.
 *
 */

#include <iostream>
#include <mpi.h>

int main(int argc, char** argv)
{
    int size, rank;
    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    //Say hello
    std::cout << "Hello, I am rank " << rank << " of " << size << " processes." << std::endl;

    if (rank == 0)
        MPI_Send(&size, 1, MPI_INT, 1, 42, MPI_COMM_WORLD);

    if (rank == 1)
        MPI_Recv(&size, 1, MPI_INT, 0, 42, MPI_COMM_WORLD, MPI_STATUS_IGNORE);

    //Say bye bye
    std::cout << "Signing off, rank " << rank << "." << std::endl;

    MPI_Finalize();

    return 0;
}
