/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// REQUIRES: addr2line

// RUN: %compile-cc
// RUN: %must-run %mpiexec-numproc-flag 1 --must:stacktrace addr2line %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck %s

// CHECK: [MUST-REPORT]{{.*Warning: from: call Annotate.*}}

/**
 * Annotation dummy to test stacktracing
 */
#include <mpi.h>
#include <MUST_Annotations.h>
#include <stdio.h>

void __attribute__((noinline)) dummy_function()
{
    // CHECK: StackTracingTestAddr2Line.c:[[@LINE+1]]
    MUST_AnnotateIntegerWarningIfZero(0);
}

int main(int argc, char** argv)
{
    int size, rank;

    MPI_Group group;
    MPI_Comm comm;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    dummy_function();

    //Say hello
    printf("Hello, I am rank %d of %d processes.\n", rank, size);

    //Say bye bye
    printf("Signing off, rank %d.\n", rank);

    MPI_Finalize();

    return 0;
}
