/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// REQUIRES: addr2line

// RUN: %compile-cc
// RUN: %must-run %mpiexec-numproc-flag 1 --must:stacktrace addr2line %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck %s

// CHECK: [MUST-REPORT]{{.*There are 2 datatypes that are not freed when MPI_Finalize}}

/**
 * Leak check type with the same MPI function (check for correct caching of locations).
 */
#include <mpi.h>
#include <stdio.h>

int main(int argc, char** argv)
{
    int size, rank;

    MPI_Group group;
    MPI_Comm comm;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    MPI_Datatype type1;
    MPI_Datatype type2;

    // CHECK-DAG: StackTracingTestAddr2LineSameMPIFunction.c:[[@LINE+1]]
    MPI_Type_contiguous(2, MPI_DOUBLE, &type1);
    /* MISSING: MPI_Type_free (&type1); */

    // CHECK-DAG: StackTracingTestAddr2LineSameMPIFunction.c:[[@LINE+1]]
    MPI_Type_contiguous(2, MPI_INT, &type2);
    /* MISSING: MPI_Type_free (&type2); */

    //Say hello
    printf("Hello, I am rank %d of %d processes.\n", rank, size);

    //Say bye bye
    printf("Signing off, rank %d.\n", rank);

    MPI_Finalize();

    return 0;
}
