#!/bin/bash
# Part of the MUST Project, under BSD-3-Clause License
# See https://hpc.rwth-aachen.de/must/LICENSE for license information.
# SPDX-License-Identifier: BSD-3-Clause

### This test checks if mustrun sets the MUST options correctly


### Check some default values 
# RUN: chmod u+x %s && %must-run --must:print-arguments | %filecheck --check-prefix=CHECK-DEFAULT %s

### Check if the "no-" prefix works, by setting some options and then unsetting them again
# RUN: %must-run --must:print-arguments --must:verbose --must:info --must:mode run --must:np -pn --must:instant-logging fatal --must:no-verbose --must:no-info --must:no-mode --must:no-np --must:no-instant-logging  | %filecheck --check-prefix=CHECK-DEFAULT %s

### Check if user-cache gets unset when mode is prepare
# RUN: %must-run --must:print-arguments --must:mode prepare --must:user-cache --must:user-cache-dir cache | %filecheck --check-prefix=CHECK-PREPARE %s

### Check if user-cache-dir gets reset if user-cache is unset
# RUN: %must-run --must:print-arguments --must:no-user-cache --must:user-cache-dir cache | %filecheck --check-prefix=CHECK-NOCACHE %s

### Check if help message is printed
# RUN: %must-run -h | %filecheck --check-prefix=CHECK-HELP %s 
# RUN: %must-run -help | %filecheck --check-prefix=CHECK-HELP %s
# RUN: %must-run --help | %filecheck --check-prefix=CHECK-HELP %s 
# RUN: %must-run --must:help | %filecheck --check-prefix=CHECK-HELP %s

### Check if version message is printed
# RUN: %must-run --must:version | %filecheck --check-prefix=CHECK-VERSION %s

### Check if hybrid is set if tsan is used, and if verbose and the remaining arguments are correctly set
# RUN: %must-run --must:print-arguments --must:verbose --must:tsan -np 12 /usr/bin/hostname | %filecheck --check-prefix=CHECK-1 %s
### Check if -h, -help, and --help are ignored after " -- " marker
# RUN: %must-run --must:print-arguments --must:mpi-process-prefix "echo" --must:layout %S/layout.xml -- -np 4 -h --help -help | %filecheck --check-prefix=CHECK-2 %s
### Check if --must: options are always parsed but -h, -help, and --help are ignored after " -- " marker
# RUN: %must-run -- --must:print-arguments --must:mpi-process-prefix "echo" --must:layout %S/layout.xml -np 4 -h --help -help | %filecheck --check-prefix=CHECK-2 %s
### Check if the help message is printed even if --must:help is after the " -- " marker
# RUN: %must-run --must:print-arguments --must:mpi-process-prefix "echo" --must:layout %S/layout.xml -np 4 -- --must:help | %filecheck --check-prefix=CHECK-HELP %s
### Check if np can be set
# RUN: %must-run --must:print-arguments --must:np -p | %filecheck --check-prefix=CHECK-3 %s
### Check if dl is set to 0 when nodl is used
# RUN: %must-run --must:print-arguments --must:nodl | %filecheck --check-prefix=CHECK-4 %s


### Check if MUST prints the help message if it does not recognize an option
# RUN: %not %must-run --must:unrecognized 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-UNRECOGNIZED %s

### Check if MUST prints the help message if an option misses its argument
# RUN: %not %must-run --must:layout --must:print-arguments 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-MISSING-ARG %s

### Check if MUST prints the help message if the argument of an option starts with "-"
# RUN: %not %must-run --must:layout -%S/layout.xml --must:print-arguments 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-MISSING-ARG %s

### Check if MUST throws an error if the layout cannot be found
# RUN: %not %must-run --must:layout %S/mylayout.xml  --must:print-arguments 2>&1 | %filecheck  --check-prefix=CHECK-MISSING-LAYOUT %s

### Check if MUST prints the help message if the argument of --must:mode is not in {run, prepare, preparerun, build, config, auto}l
# RUN: %not %must-run --must:mode unknown 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-UNKNOWN-MUST-MODE %s

### Check if MUST prints the help message if the argument of --must:language is not in {c, fortran}
# RUN: %not %must-run --must:language unknown 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-UNKNOWN-LANGUAGE %s

### Check if MUST prints the help message if the argument of --must:output is not in {html, stdout, json}
# RUN: %not %must-run --must:output unknown 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-UNKNOWN-MUST-OUTPUT %s

### Check if MUST prints the help message if the argument of --must:stacktrace is not in {none | backward}
# RUN: %not %must-run --must:stacktrace unknown 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-UNKNOWN-STACKTRACE %s

### Check if MUST prints the help message if --must:mpimode is MPMD and --must:nodesize is used
# RUN: %not %must-run --must:mpimode MPMD --must:nodesize 1 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-NODESIZE-CLOSE-MPMD %s

### Check if MUST prints the help message if --must:mpimode is MPMD and --must:close is used
# RUN: %not %must-run --must:mpimode MPMD --must:close 1 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-NODESIZE-CLOSE-MPMD %s

### Check if MUST prints the help message if --must:mpimode is SPMD and --must:openmp is used
# RUN: %not %must-run --must:mpimode SPMD --must:openmp 2>&1 | %filecheck  --check-prefixes=CHECK-HELP,CHECK-OPENMP-MPMD %s

### Check if MUST throws an error if the number of tasks are not provided
# RUN: %not %must-run 2>&1 | %filecheck  --check-prefixes=CHECK-NUM-TASKS %s

# ## Check if environment options get set
# RUN: env MUST_PRINT_ARGUMENTS=1 MUST_VERBOSE=1 MUST_MPIMODE=MPMD %must-run -np 12 /usr/bin/hostname | %filecheck --check-prefix=CHECK-ENV %s

### Check if MUST CLI options overwrite environment options
# RUN: env MUST_VERBOSE=1 MUST_MPIMODE=MPMD %must-run --must:print-arguments --must:no-verbose --must:mpimode SPMD -np 12 /usr/bin/hostname | %filecheck --check-prefix=CHECK-ENV-OW %s


# CHECK-DEFAULT-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-DEFAULT-DAG: MUST_INFO=FALSE
# CHECK-DEFAULT-DAG: MUST_VERBOSE=FALSE
# CHECK-DEFAULT-DAG: MUST_USER_CACHE=TRUE
# CHECK-DEFAULT-DAG: MUST_MODE=auto
# CHECK-DEFAULT-DAG: MUST_NP=-np -n -p
# CHECK-DEFAULT-DAG: MUST_LANGUAGE=c
# CHECK-DEFAULT-DAG: MUST_FANIN=16
# CHECK-DEFAULT-DAG: MUST_FIRSTFANIN=16
# CHECK-DEFAULT-DAG: MUST_PRECMDDDT=ddt-client
# CHECK-DEFAULT-DAG: MUST_MPIMODE=SPMD

# CHECK-PREPARE-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-PREPARE-DAG: MUST_INFO=FALSE
# CHECK-PREPARE-DAG: MUST_MODE=prepare
# CHECK-PREPARE-DAG: MUST_USER_CACHE=FALSE
# CHECK-PREPARE-DAG: MUST_USER_CACHE_DIR={{$}}
# CHECK-PREPARE-DAG: Remaining arguments: {{$}}

# CHECK-NOCACHE-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-NOCACHE-DAG: MUST_INFO=FALSE
# CHECK-NOCACHE-DAG: MUST_USER_CACHE=FALSE
# CHECK-NOCACHE-DAG: MUST_USER_CACHE_DIR={{$}}
# CHECK-NOCACHE-DAG: Remaining arguments: {{$}}

# CHECK-HELP: mustrun" from MUST v{{.*$}}
# CHECK-HELP: Prepares and runs an application that is linked with P^nMPI for runtime analysis 
# CHECK-HELP: with the MPI correctness tool MUST.
# CHECK-HELP: Replace your regular mpiexec/mpirun command with mustrun, usage:

# CHECK-VERSION: MUST v{{.*$}}
# CHECK-VERSION: based on
# CHECK-VERSION: GTI v{{.*$}}
# CHECK-VERSION: and
# CHECK-VERSION: PnMPI v{{.*$}}

# CHECK-1-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-1-DAG: MUST_VERBOSE=TRUE
# CHECK-1-DAG: MUST_TIMING=FALSE
# CHECK-1-DAG: MUST_TSAN=TRUE
# CHECK-1-DAG: MUST_HYBRID=TRUE
# CHECK-1-DAG: MUST_INFO=FALSE
# CHECK-1-DAG: Remaining arguments: -np 12 /usr/bin/hostname

# CHECK-2-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-2-DAG: MUST_INFO=FALSE
# CHECK-2-DAG: MUST_NP=-np -n -p -n
# CHECK-2-DAG: MUST_MPI_PROCESS_PREFIX=echo
# CHECK-2-DAG: MUST_LAYOUT={{([^\/]*/)*layout.xml$}}
# CHECK-2-DAG: Remaining arguments: -- -np 4 -h --help -help

# CHECK-3-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-3-DAG: MUST_INFO=FALSE
# CHECK-3-DAG: MUST_NP=-p
# CHECK-3-DAG: MUST_MPI_PROCESS_PREFIX={{$}}
# CHECK-3-DAG: MUST_LAYOUT={{$}}
# CHECK-3-DAG: Remaining arguments: {{$}}

# CHECK-4-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-4-DAG: MUST_INFO=FALSE
# CHECK-4-DAG: MUST_NODL=TRUE
# CHECK-4-DAG: MUST_DL=FALSE
# CHECK-4-DAG: Remaining arguments: {{$}}

#CHECK-UNRECOGNIZED: Unknown option --must:unrecognized

#CHECK-MISSING-ARG: Missing argument for option --must:layout

#CHECK-MISSING-LAYOUT: [MUST-ERROR] Can't find the given layout file "{{.*mylayout.xml}}"!

#CHECK-UNKNOWN-MUST-MODE: Unknown argument for option --must:mode : unknown

#CHECK-UNKNOWN-LANGUAGE: Unknown argument for option --must:language : unknown

#CHECK-UNKNOWN-MUST-OUTPUT: Unknown argument for option --must:output : unknown

#CHECK-UNKNOWN-STACKTRACE: Unknown argument for option --must:stacktrace : unknown

#CHECK-NODESIZE-CLOSE-MPMD: Cannot use nodesize or close argument together with MPMD mode

#CHECK-OPENMP-MPMD: Running OpenMP analysis without MPMD mode is unsafe

#CHECK-NUM-TASKS: [MUST-ERROR] Could not determine number of MPI tasks



# CHECK-ENV-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-ENV-DAG: MUST_VERBOSE=TRUE
# CHECK-ENV-DAG: MUST_MPIMODE=MPMD

# CHECK-ENV-OW-DAG: MUST_PRINT_ARGUMENTS=TRUE
# CHECK-ENV-OW-DAG: MUST_VERBOSE=FALSE
# CHECK-ENV-OW-DAG: MUST_MPIMODE=SPMD


