/* Part of RMARaceBench, under BSD-3-Clause License
 * See https://github.com/RWTH-HPC/RMARaceBench/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %must-cc %s -o %t.exe
// RUN: %must-run-rma-tsan -np 3 %t.exe 2>&1 | %filecheck -DFILENAME=%basename_t %s
// CHECK-DAG: data race
// CHECK-DAG: [[FILENAME]]:66
// CHECK-DAG: [[FILENAME]]:72

// RACE LABELS BEGIN
/*
{
    "RACE_KIND": "remote",
    "ACCESS_SET": ["rma atomic write","rma atomic write"],
    "RACE_PAIR": ["MPI_Accumulate@66","MPI_Accumulate@72"],
    "NPROCS": 3,
    "CONSISTENCY_CALLS": ["MPI_Win_fence"],
    "SYNC_CALLS": ["MPI_Barrier", "MPI_Win_fence"],
    "DESCRIPTION": "Two atomic operations acc and acc using a custom datatype. Since the used predefined data types are not the same, the operations are conflicting."
}
*/
// RACE LABELS END

#include <mpi.h>
#include <stdio.h>

#define PROC_NUM 3
#define WIN_SIZE 10

int main(int argc, char** argv)
{
    int rank, size;
    MPI_Win win;
    int* win_base;
    int value = 1, value2 = 2;
    int* buf = &value;
    int result;
    int token = 42;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    if (size != PROC_NUM) {
        printf("Wrong number of MPI processes: %d. Expected: %d\n", size, PROC_NUM);
        MPI_Abort(MPI_COMM_WORLD, 1);
    }

    MPI_Win_allocate(WIN_SIZE * sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win_base, &win);
    for (int i = 0; i < WIN_SIZE; i++) {
        win_base[i] = 0;
    }

    MPI_Barrier(MPI_COMM_WORLD);

    MPI_Datatype dtype;
    MPI_Type_contiguous(4, MPI_INT, &dtype);
    MPI_Type_commit(&dtype);

    MPI_Win_fence(0, win);
    if (rank == 0) {
        short value1[4] = {1, 1, 1, 1};
        // CONFLICT
        MPI_Accumulate(value1, 4, MPI_SHORT, 1, 0, 4, MPI_SHORT, MPI_SUM, win);
    }

    if (rank == 2) {
        int value2[4] = {1, 1, 1, 1};
        // CONFLICT
        MPI_Accumulate(value2, 1, dtype, 1, 0, 1, dtype, MPI_SUM, win);
    }
    MPI_Win_fence(0, win);

    MPI_Type_free(&dtype);

    MPI_Barrier(MPI_COMM_WORLD);
    printf(
        "Process %d: Execution finished, variable contents: value = %d, value2 = %d, win_base[0] = %d\n",
        rank,
        *buf,
        value2,
        win_base[0]);

    MPI_Win_free(&win);
    MPI_Finalize();

    return 0;
}
