/* Part of RMARaceBench, under BSD-3-Clause License
 * See https://github.com/RWTH-HPC/RMARaceBench/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %must-cc %s -o %t.exe
// RUN: %must-run-rma-tsan -np 2 %t.exe 2>&1 | %filecheck -DFILENAME=%basename_t %s
// CHECK-NOT: data race

// RACE LABELS BEGIN
/*
{
    "RACE_KIND": "none",
    "ACCESS_SET": ["local buffer read","load"],
    "NPROCS": 2,
    "DESCRIPTION": "Two non-conflicting operations put and load executed concurrently with no race."
}
*/
// RACE LABELS END
// RACE_KIND: none
// ACCESS_SET: [local buffer read,load]

#include <mpi.h>
#include <stdio.h>
#include <string.h>

#define PROC_NUM 2
#define WIN_SIZE 10

int main(int argc, char** argv)
{
    int rank, size;
    MPI_Win win;
    int* win_base;
    int value = 1, value2 = 2;
    int* buf = &value;
    int result;
    int token = 42;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    if (size != PROC_NUM) {
        printf("Wrong number of MPI processes: %d. Expected: %d\n", size, PROC_NUM);
        MPI_Abort(MPI_COMM_WORLD, 1);
    }

    MPI_Win_allocate(WIN_SIZE * sizeof(int), sizeof(int), MPI_INFO_NULL, MPI_COMM_WORLD, &win_base, &win);
    for (int i = 0; i < WIN_SIZE; i++) {
        win_base[i] = 0;
    }

    MPI_Win_fence(0, win);

    int* buf_alias;
    int* win_base_alias;

    memcpy(&buf_alias, &buf, sizeof(int*));
    memcpy(&win_base_alias, &win_base, sizeof(int*));

    if (rank == 0) {
        MPI_Put(buf, 1, MPI_INT, 1, 0, 1, MPI_INT, win);
        printf("*buf_alias is %d\n", *buf_alias);
    }

    MPI_Win_fence(0, win);

    MPI_Barrier(MPI_COMM_WORLD);
    printf(
        "Process %d: Execution finished, variable contents: value = %d, value2 = %d, win_base[0] = %d\n",
        rank,
        *buf,
        value2,
        win_base[0]);

    MPI_Win_free(&win);
    MPI_Finalize();

    return 0;
}
