/*
 * Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: export TYPEART_TYPES=%t.yaml
// RUN: %typeart-mpicc %s -o %t.exe

// RUN: %must-run %mpiexec-numproc-flag 2 --must:typeart \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// REQUIRES: typeart

#include <mpi.h>
#include <stdio.h>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int rank;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    int lengths[3] = {3, 3, 3};
    MPI_Aint displacements[3] = {sizeof(int), 6 * 3, 12 * sizeof(int)};
    MPI_Datatype my_own_datatype;

    MPI_Type_create_hindexed(3, lengths, displacements, MPI_INT, &my_own_datatype);
    MPI_Type_commit(&my_own_datatype);

    int buffer[20] = {1};

    if (rank == 0) {
        // CHECK: Incompatible stride for buffer type int for MUST_type_hindexed with base type MPI_INT
        MPI_Send(buffer, 1, my_own_datatype, 1, 0, MPI_COMM_WORLD);
    } else if (rank == 1) {
        MPI_Recv(buffer, 1, my_own_datatype, 0, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    }

    MPI_Type_free(&my_own_datatype);
    MPI_Finalize();
    return 0;
}
