/*
 * Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: export TYPEART_TYPES=%t.yaml
// RUN: %typeart-mpicc -O2 %s -o %t.exe

// RUN: %must-run %mpiexec-numproc-flag 2 --must:typeart \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// REQUIRES: typeart

#include <mpi.h>
#include <stdio.h>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int rank;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    int block_count = 3;               // Number of blocks
    int block_length = 2;              // Number of elements per block
    MPI_Aint stride = 3 * sizeof(int); // Stride in bytes (distance between blocks)

    MPI_Datatype my_hvector_type;
    MPI_Type_create_hvector(block_count, block_length, stride, MPI_INT, &my_hvector_type);
    MPI_Type_commit(&my_hvector_type);

    int buffer[20] = {0}; // Large enough buffer

    if (rank == 0) {
        // CHECK: MUST detected no MPI usage errors
        MPI_Send(buffer, 1, my_hvector_type, 1, 0, MPI_COMM_WORLD);
    } else if (rank == 1) {
        MPI_Recv(buffer, 1, my_hvector_type, 0, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    }

    MPI_Type_free(&my_hvector_type);
    MPI_Finalize();
    return 0;
}
