/*
 * Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: export TYPEART_TYPES=%t.yaml
// RUN: %typeart-mpicc -O2 %s -o %t.exe

// RUN: %must-run %mpiexec-numproc-flag 2 --must:typeart \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// REQUIRES: typeart

#include <mpi.h>

typedef struct Cpx {
    float imag;
    float real;
} complex;

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int rank;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    complex f = {1.0, 2.0};

    MPI_Datatype new_datatype; // New datatype for the contiguous block
    MPI_Type_contiguous(2, MPI_FLOAT, &new_datatype);
    MPI_Type_commit(&new_datatype);

    if (rank == 0) {
        // CHECK-NOT: Error
        MPI_Send(&f.imag, 1, new_datatype, 1, 0, MPI_COMM_WORLD);
    } else if (rank == 1) {
        MPI_Recv(&f, 1, new_datatype, 0, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    }

    MPI_Type_free(&new_datatype);

    MPI_Finalize();
    return 0;
}