// Originally from TypeART library test base
/*
 * Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: export TYPEART_TYPES=%t.yaml
// RUN: %typeart-mpicc -O2 %s -o %t.exe

// RUN: %must-run %mpiexec-numproc-flag 2 --must:typeart \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// REQUIRES: typeart

#include <mpi.h>

typedef struct SubStruct {
    double x;
} Sub;

typedef struct {
    float imag;
    float real;
    Sub s;
} complex_2;

void g_complexsum(complex_2* cpt)
{
    complex_2 work;
    // CHECK: Not yet implemented: Resolving nested struct typemap.
    MPI_Allreduce(&cpt->real, &work.real, 2, MPI_FLOAT, MPI_SUM, MPI_COMM_WORLD);
    *cpt = work;
}

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);
    int rank;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    complex_2 c = {1.0, 2.0}; // This allocation becomes an int64 with a bit-mask store
    g_complexsum(&c);

    MPI_Finalize();
    return 0;
}
