/*
 * Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: export TYPEART_TYPES=%t.yaml
// RUN: %typeart-mpicc %s -o %t.exe

// RUN: %must-run %mpiexec-numproc-flag 2 --must:typeart \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// REQUIRES: typeart

#include <mpi.h>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int rank;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    const int buffer_len = 3;
    double f[buffer_len];

    MPI_Datatype new_datatype; // New datatype for the contiguous block
    MPI_Type_contiguous(buffer_len, MPI_LONG, &new_datatype);
    MPI_Type_commit(&new_datatype);

    if (rank == 0) {
        // CHECK: Incompatible buffer of type double (type id=24) - expected MUST_type_contiguous with base type MPI_LONG instead
        MPI_Send(f, 1, new_datatype, 1, 0, MPI_COMM_WORLD);
    } else if (rank == 1) {
        // CHECK: Incompatible buffer of type double (type id=24) - expected MUST_type_contiguous with base type MPI_LONG instead
        MPI_Recv(f, 1, new_datatype, 0, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
    }

    MPI_Type_free(&new_datatype);

    MPI_Finalize();
    return 0;
}
