/*
 * Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: export TYPEART_TYPES=%t.yaml
// RUN: %typeart-mpicc %s -o %t.exe

// RUN: %must-run %mpiexec-numproc-flag 2 --must:typeart \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// REQUIRES: typeart

#include <mpi.h>
#include <stdlib.h>

#define ARRAY_LENGTH 11

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int rank;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (rank == 0) {
        unsigned int* a = (unsigned int*)malloc(ARRAY_LENGTH * sizeof(unsigned int));
        // CHECK: call MPI_Send@0: Incompatible buffer of type unsigned int (type id=18) - expected MPI_INT
        MPI_Send(a, ARRAY_LENGTH, MPI_INT, 1, 0, MPI_COMM_WORLD);
        free(a);
    } else if (rank == 1) {
        int* b = (int*)malloc(ARRAY_LENGTH * sizeof(int));
        MPI_Recv(b, ARRAY_LENGTH, MPI_INT, 0, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
        free(b);
    }

    MPI_Finalize();
    return 0;
}