#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <MUST_Annotations.h>

/**
 * @file VCAnnotateProcessSignalWaitTransitive.cpp
 *       Annotated process synchronization example with transitive synchronization
 *
 *  @date 17.02.2022
 *  @author Simon Schwitanski
 */

// RUN: %compile-cxx
// RUN: %must-run --must:layout \
// RUN: %builddir/tests/VectorClock/VCAnnotateProcessSignalWaitTransitiveLayout.xml \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// CHECK-DAG: shutdown(0){{.*}}clk=(1, 0, 0)
// CHECK-DAG: shutdown(1){{.*}}clk=(1, 2, 0)
// CHECK-DAG: shutdown(2){{.*}}clk=(1, 2, 1)

int main(int argc, char** argv)
{
    int rank, size;
    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    if (rank == 0) {
        MUST_AnnotateTick();
        MUST_AnnotateProcessSignal(1, 0, MPI_COMM_WORLD);

    } else if (rank == 1) {
        MUST_AnnotateTick();
        MUST_AnnotateTick();
        MUST_AnnotateProcessWait(0, 0, MPI_COMM_WORLD);
        MUST_AnnotateProcessSignal(2, 0, MPI_COMM_WORLD);
    } else if (rank == 2) {
        MUST_AnnotateTick();
        MUST_AnnotateProcessWait(1, 0, MPI_COMM_WORLD);
    }

    MPI_Finalize();
}
