// RUN: %compile-cxx

// RUN: %must-run %mpiexec-numproc-flag 3 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer[10];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (numProcs < 3) {
        printf("This test needs at least three processes.\n");
        MPI_Finalize();
        return 1;
    }

    MPI_Win win;
    MPI_Win_create(win_buffer, 10 * sizeof(int), 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    MPI_Group world_group;
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);
    if (rank == 0) {
        // Initiate access epoch
        MPI_Group group;
        int targets[2] = {1, 2};
        MPI_Group_incl(world_group, 2, targets, &group);
        MPI_Win_start(group, 0, win);
        MPI_Win_complete(win);
        MPI_Barrier(MPI_COMM_WORLD);
        MPI_Win_start(group, 0, win);
        MPI_Win_complete(win);
        MPI_Group_free(&group);
    } else if (rank == 1 || rank == 2) {
        // Initiate exposure epoch
        MPI_Group group;
        int origin = 0;
        MPI_Group_incl(world_group, 1, &origin, &group);
        MPI_Win_post(group, 0, win);
        MPI_Win_wait(win);
        MPI_Barrier(MPI_COMM_WORLD);
        MPI_Win_post(group, 0, win);
        MPI_Win_wait(win);
        MPI_Group_free(&group);
    }

    MPI_Group_free(&world_group);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
