// RUN: %compile-cxx

// RUN: %must-run %mpiexec-numproc-flag 3 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer[10];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (numProcs < 3) {
        printf("This test needs at least three processes.\n");
        MPI_Finalize();
        return 1;
    }

    MPI_Win win;
    MPI_Win_create(win_buffer, 10 * sizeof(int), 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    MPI_Group world_group;
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);
    if (rank == 0) {
        MPI_Group access_group, exposure_group;
        int targets[2] = {1, 2};
        MPI_Group_incl(world_group, 2, targets, &access_group);
        MPI_Group_incl(world_group, 2, targets, &exposure_group);
        MPI_Win_post(exposure_group, 0, win);
        MPI_Win_start(access_group, 0, win);
        int local_buf[10] = {0};
        MPI_Put(local_buf, 10, MPI_INT, 1, 0, 10, MPI_INT, win);
        MPI_Put(local_buf, 10, MPI_INT, 2, 0, 10, MPI_INT, win);
        MPI_Win_complete(win);
        MPI_Win_wait(win);
        MPI_Group_free(&access_group);
        MPI_Group_free(&exposure_group);
    } else if (rank == 1 || rank == 2) {
        MPI_Group access_group, exposure_group;
        int origin = 0;
        MPI_Group_incl(world_group, 1, &origin, &access_group);
        MPI_Group_incl(world_group, 1, &origin, &exposure_group);
        MPI_Win_post(exposure_group, 0, win);
        MPI_Win_start(access_group, 0, win);
        int local_buf[1] = {0};
        MPI_Put(local_buf, 1, MPI_INT, 0, rank, 1, MPI_INT, win);
        MPI_Win_complete(win);
        MPI_Win_wait(win);
        MPI_Group_free(&access_group);
        MPI_Group_free(&exposure_group);
    }

    MPI_Group_free(&world_group);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
