// RUN: %compile-cxx

// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

// CHECK-DAG: [MUST-REPORT]{{.*Error.*RMA communication call outside of an active access epoch.}}

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer[10];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (numProcs < 2) {
        printf("This test needs at least two processes.\n");
        MPI_Finalize();
        return 1;
    }

    MPI_Win win;
    MPI_Win_create(win_buffer, 10 * sizeof(int), 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    if (rank == 0) {
        int local_buf[10] = {0};
        MPI_Put(local_buf, 10, MPI_INT, 1, 0, 10, MPI_INT, win);
    }

    MPI_Win_fence(0, win);

    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
