// RUN: %compile-cxx

// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck-may-segfault %s

// CHECK: [MUST-REPORT]{{.*Error:.*Overlapping MPI_Win_attach.}}

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer1[10];
    int* win_buffer2 = &win_buffer1[5];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    MPI_Win win;
    MPI_Win_create_dynamic(MPI_INFO_NULL, MPI_COMM_WORLD, &win);
    MPI_Win_attach(win, win_buffer1, 10 * sizeof(int));
    MPI_Win_attach(win, win_buffer2, 5 * sizeof(int));

    MPI_Win_detach(win, win_buffer1);
    MPI_Win_detach(win, win_buffer2);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
