// RUN: %compile-cxx

// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

#define N 10

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer1[N];
    int win_buffer2[N];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    MPI_Win win;
    MPI_Win_create_dynamic(MPI_INFO_NULL, MPI_COMM_WORLD, &win);
    MPI_Win_attach(win, win_buffer1, N * sizeof(int));
    MPI_Win_attach(win, win_buffer2, N * sizeof(int));

    MPI_Win_detach(win, win_buffer1);
    MPI_Win_detach(win, win_buffer2);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
