// RUN: %compile-cxx

// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck-may-segfault %s

// CHECK: [MUST-REPORT]{{.*Warning:.*Overlapping windows.}}

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer[10];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    MPI_Win win1, win2;
    MPI_Win_create(win_buffer, 10 * sizeof(int), 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win1);
    MPI_Win_create(win_buffer, 10 * sizeof(int), 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win2);

    MPI_Win_free(&win1);
    MPI_Win_free(&win2);

    MPI_Finalize();

    return 0;
}
