
// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 4 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck-may-segfault  %s
// CHECK-DAG: [MUST-REPORT]{{.*Error:.*specifies at least one rank that is not in the window's communicator:}}

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer[10];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (numProcs < 4) {
        printf("This test needs at least four processes.\n");
        MPI_Finalize();
        return 1;
    }

    MPI_Comm myComm;
    MPI_Comm_split(MPI_COMM_WORLD, (rank < 2), 0, &myComm);
    if (rank < 2) {
        MPI_Win win;
        MPI_Group world_group;
        MPI_Comm_group(MPI_COMM_WORLD, &world_group);
        MPI_Win_create(win_buffer, 10 * sizeof(int), 1, MPI_INFO_NULL, myComm, &win);

        // Create a group that is not in the window
        const int ranks[2] = {2, 3};
        MPI_Group rmaGroup;
        MPI_Group_incl(world_group, 2, ranks, &rmaGroup);

        MPI_Win_post(rmaGroup, 0, win);
        MPI_Win_start(rmaGroup, 0, win);

        MPI_Win_complete(win);
        MPI_Win_wait(win);

        MPI_Win_free(&win);
        MPI_Group_free(&rmaGroup);
        MPI_Group_free(&world_group);
    }
    MPI_Comm_free(&myComm);
    MPI_Finalize();

    return 0;
}
