
// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck-may-segfault  %s

// CHECK-DAG: [MUST-REPORT]{{.*Error:.*is MPI_WIN_NULL where a valid window was expected.}}

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    int rank, numProcs;
    int win_buffer[10];

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    if (numProcs < 2) {
        printf("This test needs at least two processes.\n");
        MPI_Finalize();
        return 1;
    }

    MPI_Win_lock_all(0, MPI_WIN_NULL);

    MPI_Win_unlock_all(MPI_WIN_NULL);

    MPI_Finalize();

    return 0;
}
