/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <sys/resource.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <mpi.h>
#ifdef PMPIPREFIX
#include "pnmpimod.h"
#include <assert.h>
#endif

int MPI_Finalize()
{
    int rank, print_rank = 1, all = 0;
    char* print_str = getenv("MUST_PRINT_RANK");
    if (print_str != NULL) {
        if (strcmp("all", print_str) == 0)
            all = 1;
        else
            print_rank = atoi(print_str);
    }
#ifdef PMPIPREFIX
    PNMPI_modHandle_t stack = 0;
#ifndef NDEBUG
    int err =
#endif
        PNMPI_Service_GetStackByName("level_0", &stack);
    assert(err == PNMPI_SUCCESS);
    XMPI_Comm_rank_NewStack(stack, MPI_COMM_WORLD, &rank);
#else
    PMPI_Comm_rank(MPI_COMM_WORLD, &rank);
#endif

    if (all || rank == print_rank) {
        struct rusage end;
        getrusage(RUSAGE_SELF, &end);
        printf("%i: MAX RSS[KBytes] during execution: %ld\n", rank, end.ru_maxrss);
    }
#ifdef PMPIPREFIX
    return XMPI_Finalize();
#else
    return PMPI_Finalize();
#endif
}
